/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.command;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.command.DumpAllTagsCommand;
import slimeknights.mantle.command.DumpTagCommand;

public class DumpLootModifiers {
    protected static final class_2960 GLOBAL_LOOT_MODIFIERS = new class_2960("mantle", "loot_modifiers/global_loot_modifiers.json");
    private static final String LOOT_MODIFIER_PATH = GLOBAL_LOOT_MODIFIERS.method_12836() + "/" + GLOBAL_LOOT_MODIFIERS.method_12832();
    private static final class_2561 LOOT_MODIFIER_SUCCESS_LOG = class_2561.method_43471((String)"command.mantle.dump_loot_modifiers.success_log");
    protected static final SimpleCommandExceptionType ERROR_READING_LOOT_MODIFIERS = new SimpleCommandExceptionType((Message)class_2561.method_43469((String)"command.mantle.dump_loot_modifiers.read_error", (Object[])new Object[]{GLOBAL_LOOT_MODIFIERS}));

    public static void register(LiteralArgumentBuilder<class_2168> subCommand) {
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)subCommand.requires(sender -> sender.method_9259(1))).then(class_2170.method_9247((String)"save").executes(source -> DumpLootModifiers.run((CommandContext<class_2168>)source, true)))).then(class_2170.method_9247((String)"log").executes(source -> DumpLootModifiers.run((CommandContext<class_2168>)source, false)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int run(CommandContext<class_2168> context, boolean saveFile) throws CommandSyntaxException {
        ArrayList<class_2960> finalLocations = new ArrayList<class_2960>();
        class_3300 manager = ((class_2168)context.getSource()).method_9211().method_34864();
        for (Object resource : manager.method_14489(GLOBAL_LOOT_MODIFIERS)) {
            try {
                BufferedReader reader = resource.method_43039();
                try {
                    JsonObject json = (JsonObject)class_3518.method_15276((Gson)DumpTagCommand.GSON, (Reader)reader, JsonObject.class);
                    if (json == null) {
                        Mantle.logger.error("Couldn't load global loot modifiers from {} in data pack {} as it is empty or null", (Object)GLOBAL_LOOT_MODIFIERS, (Object)resource.method_14480());
                        continue;
                    }
                    if (class_3518.method_15258((JsonObject)json, (String)"replace", (boolean)false)) {
                        finalLocations.clear();
                    }
                    JsonArray entryList = class_3518.method_15261((JsonObject)json, (String)"entries");
                    for (JsonElement entry : entryList) {
                        class_2960 res = class_2960.method_12829((String)class_3518.method_15287((JsonElement)entry, (String)"entry"));
                        if (res == null) continue;
                        finalLocations.remove(res);
                        finalLocations.add(res);
                    }
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (IOException | RuntimeException ex) {
                Mantle.logger.error("Couldn't read global loot modifier list {} in data pack {}", (Object)GLOBAL_LOOT_MODIFIERS, (Object)resource.method_14480(), (Object)ex);
            }
        }
        JsonArray entries = new JsonArray();
        for (class_2960 location : finalLocations) {
            entries.add(location.toString());
        }
        JsonObject json = new JsonObject();
        json.addProperty("replace", Boolean.valueOf(false));
        json.add("entries", (JsonElement)entries);
        if (saveFile) {
            File output = new File(DumpAllTagsCommand.getOutputFile(context), LOOT_MODIFIER_PATH);
            Path path = output.toPath();
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                    writer.write(DumpTagCommand.GSON.toJson((JsonElement)json));
                }
            }
            catch (IOException ex) {
                Mantle.logger.error("Couldn't save global loot manager to {}", (Object)path, (Object)ex);
            }
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43469((String)"command.mantle.dump_loot_modifiers.success_save", (Object[])new Object[]{DumpAllTagsCommand.getOutputComponent(output)}), true);
        } else {
            ((class_2168)context.getSource()).method_9226(() -> LOOT_MODIFIER_SUCCESS_LOG, true);
            Mantle.logger.info("Dump of global loot modifiers:\n{}", (Object)DumpTagCommand.GSON.toJson((JsonElement)json));
        }
        return finalLocations.size();
    }
}

